// Ksztsnk tbbszl alkalmazst, ahol szlak
// tglalapot jelentenek meg vletlen pozciban s sznnel.
// A szlobjektumok trolshoz hasznljuk objektumlistt!
unit SzalGrafU;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, Contnrs, Math, syncobjs;

type
  TSzalakForm = class(TForm)
    MainMenu1: TMainMenu;
    Muveletek: TMenuItem;
    SzalHozzaadasa: TMenuItem;
    SzalLevetele: TMenuItem;
    ColorDialog1: TColorDialog;
    VeletlenSzal: TMenuItem;
    MindenLevetele: TMenuItem;
    Kilepes: TMenuItem;
    PillanatFelvetel: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SzalHozzaadasaClick(Sender: TObject);
    procedure SzalLeveteleClick(Sender: TObject);
    procedure VeletlenSzalClick(Sender: TObject);
    procedure MindenLeveteleClick(Sender: TObject);
    procedure KilepesClick(Sender: TObject);
    procedure Kijelzes(db:Integer);
    procedure PillanatFelvetelClick(Sender: TObject);
  private
    SzalLista: TObjectList;
  public
    { Public declarations }
  end;

  TRajzoloSzal = class(TThread)
  private
    FColor: TColor;
    FForm: TForm;
  public
    constructor Create(AForm: TForm; AColor: TColor);
    procedure Execute; override;
  end;

var
  SzalakForm: TSzalakForm;

implementation

{$R *.DFM}

resourcestring
   Fejlec='Tbbszl grafikus alkalmazs';

// ----------------------------------------
// TRajzoloSzal metdusok
// ----------------------------------------
constructor TRajzoloSzal.Create(AForm: TForm; AColor: TColor);
begin
  FColor := AColor;
  FForm := AForm;
  inherited Create(False);
end;

procedure TRajzoloSzal.Execute;

  function VeletlenTeglalap:Trect;
  var
    MaxX, MaxY: Integer;
  begin
    MaxX := FForm.ClientWidth;
    MaxY := FForm.ClientHeight;
    result.left   := Random(MaxX-100);
    result.top    := Random(MaxY-100);
    result.right  := result.left+100;
    result.bottom := result.top+100;
  end;

var
  R : TRect;
begin
  // Meglls utn megsznik a szl
  FreeOnTerminate := True;
  // A szl legfeljebb az alkalmazs megllsig fut
  while not (Terminated or Application.Terminated) do
  begin
    R:=VeletlenTeglalap;
    with FForm.Canvas do
    begin
      Lock;   // a canvas lezrsa
      // a kvetkez utastsokat egy idben csak egy szl hajthatja vgre
      Pen.Color := FColor;
      Brush.Style:=bsClear;
      with r do Rectangle(left, top, right, bottom);
      Unlock; // a canvas megnyitasa
    end;
  end;
end;

// ----------------------------------------
// TSzalakForm metdusok
// ----------------------------------------
procedure TSzalakForm.FormCreate(Sender: TObject);
begin
  // Objektumlista a szlobjektumok trolsra
  SzalLista := TObjectList.Create;
  // A lista nem trli a levett szlakat
  SzalLista.OwnsObjects:=false;
  Kijelzes(0);
end;

procedure TSzalakForm.FormDestroy(Sender: TObject);
begin
  // Minden szl levtele a listbl
  MindenLeveteleClick(nil);
  // Az objektumlista lebontsa
  SzalLista.Free;
end;

procedure TSzalakForm.Kijelzes(db:Integer);
begin
  caption:=fejlec+format(' - a szlak szma: %03d.',[db]);
end;

procedure TSzalakForm.SzalHozzaadasaClick(Sender: TObject);
begin
  // j szl ltrehozsa a bekrt szn tadsval s hozzadsa a listhoz
  if ColorDialog1.Execute then
   begin
     with SzalLista do
       begin
         Add(TRajzoloSzal.Create(Self, ColorDialog1.Color));
         TRajzoloSzal(SzalLista[Szallista.count-1]).Priority := tpLowest;
         Kijelzes(SzalLista.count);
       end;
   end;
end;

procedure TSzalakForm.SzalLeveteleClick(Sender: TObject);
begin
  if SzalLista.Count>0 then
    begin
      // az utols szl kivtele a listbl s a szl trlse
      TRajzoloSzal(SzalLista[SzalLista.Count - 1]).Terminate;
      SzalLista.Delete(SzalLista.Count - 1);
      Kijelzes(SzalLista.Count);
      if SzalLista.Count=0 then Invalidate;
    end;
end;

procedure TSzalakForm.VeletlenSzalClick(Sender: TObject);
var
  i: Integer;
begin
  // Vletlen szm szl felvtele a listba
  // vletlen sznbelltsokkal
  for i := 1 to 2+random(10) do
    SzalLista.Add(TRajzoloSzal.Create(Self,
                  rgb(Random(256),Random(256),Random(256))));
  Kijelzes(SzalLista.count);
end;

procedure TSzalakForm.MindenLeveteleClick(Sender: TObject);
var
  i: Integer;
begin
  Cursor := crHourGlass;
  try
    for i := SzalLista.Count - 1 downto 0 do
    begin
      TRajzoloSzal(SzalLista[i]).Terminate;
      TRajzoloSzal(SzalLista[i]).WaitFor;
    end;
    SzalLista.Clear;
    Kijelzes(SzalLista.count);
    Repaint;
  finally
    Cursor:= crDefault;
  end;
end;

procedure TSzalakForm.KilepesClick(Sender: TObject);
begin
  Close;
end;

procedure TSzalakForm.PillanatFelvetelClick(Sender: TObject);
var
  i:Integer;
begin
   for i:=0 to SzalLista.Count-1 do
     TRajzoloSzal(SzalLista[i]).Suspend;
   Sleep(1000);
   for i:=SzalLista.Count-1 downto 0 do
     TRajzoloSzal(SzalLista[i]).Resume;
end;

initialization
  Randomize;
end.
